/////////////////////////////////////////////////////////////////////////////////

// Original obtained from GlsSandbox.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// The originals of these shaders did not take gl_FragCoord.w  into
// account so the iStripper scale attribute would  have  no  effect
// when used ina scene node that used one of them. I have therefore
// performed a global replace to substitute scaled_gl_FragCoord for
// gl_FragCoord and declare it here. TheEmu 2016/12/15

#define scaled_gl_FragCoord vec4(gl_FragCoord.xyz*gl_FragCoord.w,1.0)

// Use defines here rather than edit the body of the code.

#define time u_Elapsed
#define resolution u_WindowSize
#define mouse vec2(0.0,0.0)
#define surfacePosition ( scaled_gl_FragCoord.xy / u_WindowSize )

/////////////////////////////////////////////////////////////////////////////////
 
#ifdef GL_ES
precision mediump float;
#endif

// uniform vec2  resolution;
// uniform float  time;

void main() {

  vec2 p = (scaled_gl_FragCoord.xy * 2.0 - resolution) / min(resolution.x,resolution.y);

  float radius = 0.9;
  float radiusMovSpeed = 1.0;
  float speed = 100.0;
  float timeSpeedDiff = 0.11;
  float circleSize = 0.03;
  float distanceDiff = 0.1;

  vec3 colorDest = vec3(0.0);

  for(float i = 0.0;i < 19.0; i++){
    float j = i + 1.0;
    vec2 q = p+ vec2((radius*cos(radiusMovSpeed))*cos((speed+timeSpeedDiff*j) + j*distanceDiff),(radius*sin(time*radiusMovSpeed))*sin(time*(speed+timeSpeedDiff*j) + j*distanceDiff));
    float l = circleSize/length(q);
    colorDest += vec3(l-1.0,l-0.09,l-0.05);
  }

  colorDest = clamp ( colorDest, 0.0, 1.0 );
  gl_FragColor.rgb = colorDest;
  gl_FragColor.a = length(colorDest);
   gl_FragColor *= gl_Color; // TheEmu 2016/12/15

}